public class Solution {
    public String makeString(String message) {
        if (message == null || message.length() == 0) {
            return ""; // 如果输入为空字符串，直接返回空字符串
        }

        StringBuilder sb = new StringBuilder(message);

        int i = 0;
        while (i < sb.length() - 1) {
            char c1 = sb.charAt(i);
            char c2 = sb.charAt(i + 1);
            if (Character.isLowerCase(c1) && Character.isUpperCase(c2) && Character.toLowerCase(c2) == c1) {
                sb.delete(i, i + 2); // 删除相邻的两个字符
                i = Math.max(0, i - 1);
            } else if (Character.isUpperCase(c1) && Character.isLowerCase(c2) && Character.toUpperCase(c2) == c1) {
                sb.delete(i, i + 2); // 删除相邻的两个字符
                i = Math.max(0, i - 1);
            } else {
                i++;
            }
        }

        return sb.toString();
    }

    public static void main(String[] args) {
        Solution solution = new Solution();

        // 测试用例1
        String str1 = "HogGgwarts";
        System.out.println(solution.makeString(str1)); // 输出: Hogwarts

        // 测试用例2
        String str2 = "abBAcC";
        System.out.println(solution.makeString(str2)); // 输出: （应该为空字符串）
    }
}