from selenium.webdriver.common.by import By

from gitlab_webtest.base.base_page import BasePage
from gitlab_webtest.page.myproject_page import MyProjectPage


class MainPage(BasePage):

    def click_projects(self):
        self.find_ele_click(
            By.XPATH, '//*[@class="active-indicator gl-absolute gl-left-2 gl-top-2 gl-bottom-2 gl-transition-slow gl-opacity-10"]'
        )
        return self

    def goto_my_project(self):
        self.find_ele_click(
            By.XPATH, '//*[@class="project-name"]'
        )
        return MyProjectPage(self._driver)