from selenium.webdriver.common.by import By

from gitlab_webtest.base.base_page import BasePage
from gitlab_webtest.page.main_page import MainPage


class LoginPage(BasePage):

    def login(self, username, password):
        self.open_url("https://contest.gitlab.ceba.ceshiren.com/users/sign_in")
        self.find_ele_send(By.ID, 'user_login', username)
        self.find_ele_send(By.ID, 'user_password', password)
        self.find_ele_click(By.XPATH, '//*[@data-testid = "sign-in-button"]')
        return MainPage(self._driver)
