from selenium.webdriver.common.by import By

from gitlab_webtest.base.base_page import BasePage
from gitlab_webtest.page.lssues_detail_page import IssuesDetailPage


class NewIssuesPage(BasePage):

    def input_title(self, title):
        self.find_ele_send(By.ID, "issue_title", title)
        return self

    def click_assign_to_me(self):
        self.find_ele_click(By.XPATH, '//*[@data-testid="assign-to-me-link"]')
        return self

    def click_create_issue(self):
        self.find_ele_click(By.XPATH, '//*[@data-testid="issuable-create-button"]')
        return IssuesDetailPage(self._driver)