from selenium.webdriver.common.by import By

from gitlab_webtest.base.base_page import BasePage
from gitlab_webtest.page.new_lssues_page import NewIssuesPage


class IssuesListPage(BasePage):

    def goto_new_issue(self):
        self.find_ele_click(By.XPATH, '//*[@data-testid="issues-list-more-actions-dropdown"]/./..//*[@class="btn gl-flex-grow-1 btn-confirm btn-md gl-button"]')
        return NewIssuesPage(self._driver)

    def search_issue(self, title):
        self.find_ele_send(By.XPATH, '//*[@data-testid="filtered-search-term-input"]', title)
        self.find_ele_click(By.XPATH, '//*[@data-testid="search-button"]')
        issues_list = self.find_eles(By.XPATH, '//*[@data-testid="issuable-title-link"]')
        result_list = []
        for i in issues_list:
            result_list.append(i.text)
        return result_list
