import os
import time
import allure
import yaml
from selenium import webdriver
from selenium.webdriver.chrome.webdriver import WebDriver
from selenium.webdriver.support import expected_conditions
from selenium.webdriver.support.wait import WebDriverWait

from gitlab_webtest.utils.log_utils import logger


class BasePage:
    def __init__(self, driver: WebDriver = None):
        if driver is None:
            self._driver = webdriver.Chrome()
            self._driver.implicitly_wait(15)
            self._driver.maximize_window()
        else:
            self._driver = driver

    def find_ele(self, by, locate):
        try:
            ele = self._driver.find_element(by, locate)
        except Exception as e:
            ele = None
            # 保存截图
            self.screen_image()
            logger.info(f"元素{locate}未找到，具体错误信息为{e}")
        return ele

    def find_eles(self, by, locate):
        try:
            eles = self._driver.find_elements(by, locate)
        except Exception as e:
            eles = None
            self.screen_image()
            logger.info(f"元素{locate}未找到，具体错误信息为{e}")
        return eles

    def wait_locate(self, time, by, locate):
        ele = WebDriverWait(self._driver, time).until(
            expected_conditions.visibility_of_element_located((by, locate)))
        return ele

    def open_url(self, url):
        self._driver.get(url)

    def set_cookie(self, path):
        with open(path, "r", encoding="utf-8") as f:
            cookies = yaml.safe_load(f)
        for i in cookies:
            self._driver.add_cookie(i)
        self._driver.refresh()

    def close_brower(self):
        self._driver.quit()

    def get_path(self, path_name):
        '''
        获取绝对路径
        :param path_name: 目录名称
        :return: 目录绝对路径
        '''
        # 获取当前工具文件所在的路径
        root_path = os.path.dirname(os.path.abspath(__file__))
        # 拼接当前要输出日志的路径
        dir_path = os.sep.join([root_path, '..', f'/{path_name}'])
        return dir_path

    def screen_image(self):
        '''
        截图
        :return: 图片保存路径
        '''
        # 截图命名
        now_time = time.strftime('%Y_%m_%d_%H_%M_%S')
        image_name = f"{now_time}.png"
        # 拼接截图保存路径
        # windows f"{self.get_path('image')}\\{image_name}"
        image_path = f"{self.get_path('image')}/{image_name}"
        logger.info(f"截图保存路径为 {image_path}")
        # 截图
        self._driver.save_screenshot(image_path)
        allure.attach.file(image_path, name='image_name', attachment_type=allure.attachment_type.PNG)
        return image_path

    def save_page_source(self):
        '''
        保存页面源码
        :return: 页面源码保存路径
        '''
        # 文件命名
        now_time = time.strftime('%Y_%m_%d_%H_%M_%S')
        pagesource_name = f"{now_time}_pagesource.html"
        # 拼接文件保存路径
        # windows f"{self.get_path('pagesource')}\\{pagesource_name}"
        pagesource_path = f"{self.get_path('pagesource')}/{pagesource_name}"
        logger.info(f"页面源码文件保存路径为 {pagesource_path}")
        # 保存 page source
        with open(pagesource_path, "w", encoding="utf-8") as f:
            f.write(self.driver.page_source)
        return pagesource_path

    def find_ele_send(self, by, locate, text):
        try:
            ele = self._driver.find_element(by, locate).send_keys(text)
        except Exception as e:
            ele = None
            # 保存截图
            self.screen_image()
            logger.info(f"元素{locate}未找到，具体错误信息为{e}")
        return ele

    def find_ele_click(self, by, locate):
        try:
            ele = self._driver.find_element(by, locate).click()
        except Exception as e:
            ele = None
            # 保存截图
            self.screen_image()
            logger.info(f"元素{locate}未找到，具体错误信息为{e}")
        return ele