

def pass_the_flower(n, s):
    """
    题目描述
    有 n 个人站成一排，按从 1 到 n 编号。
    当游戏开始时，会每秒种击一次鼓。
    排在队首的第一个人拿着花。每击一次鼓，持花人会将花传递给队伍中的下一个人。
    一旦花到达队首或队尾，传递方向就会改变，队伍会将花继续沿相反方向传递。
    例如，当花到达第 n 个人时，TA 会将花传递给第 n - 1 个人，然后传递给第n - 2 个人，依此类推。

    给你两个正整数 n 和 s ，返回 s 秒后拿着花的人的编号。

    示例
    # 示例 1：
    # 输入：n = 4, s = 5
    # 输出：2
    # 解释：队伍中花的传递情况为：1 -> 2 -> 3 -> 4 -> 3 -> 2 。
    # 5 秒后，花传递到第 2 个人手中。

    # 示例 2：
    # 输入：n = 3, s = 2
    # 输出：3
    # 解释：队伍中花的传递情况为：1 -> 2 -> 3 。
    # 2 秒后，花传递到第 3 个人手中。
    """

    one_time = 2 * n - 2
    remainder = s % one_time

    if remainder < n - 1:
        result = remainder + 1
    else:
        result = n - (remainder - (n - 1))

    return result

if __name__ == '__main__':
    n1, s1 = 8, 8
    print(pass_the_flower(n1, s1))

    n2, s2 = 3, 2
    print(pass_the_flower(n2, s2))
