
def make_string(s):
    """
    给你一个由大小写英文字母组成的字符串 s 。
    一个整理好的字符串中，两个相邻字符 s[i] 和 s[i+1]，其中 0<= i <= s.length-2 ，要满足如下条件:

    若 s[i] 是小写字符，则 s[i+1] 不可以是相同的大写字符。
    若 s[i] 是大写字符，则 s[i+1] 不可以是相同的小写字符。
    请你将字符串整理好，每次你都可以从字符串中选出满足上述条件的两个相邻字符并删除，直到字符串整理好为止。

    返回整理好的字符串。
    注意：空字符串也属于整理好的字符串，尽管其中没有任何字符。
    """
    stack = []

    for char in s:
        if stack and (stack[-1].swapcase() == char):
            stack.pop()
        else:
            stack.append(char)

    result = ''.join(stack)
    return result

if __name__ == '__main__':
    str = make_string("HogGgwarts")
    print(str)

    str2 = make_string("abBAc C")
    print(str2)